<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasOne;
// use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Model;

class Member extends Model
{
    use HasFactory;
    protected $fillable = [
        'kd_member',
        'nm_member',
        'hp_member',
        'email_member',
        'kelamin_member',
        'username',
        'password',
    ];

    public function ongkirmember(): HasOne
    {
        return $this->hasOne(Ongkirmember::class);
    }

    public function scopePencarian(Builder $query): void
    {
        $query->where('nm_member', 'like', '%' . request('cari') . '%')->orWhere('kd_member', 'like', '%' . request('cari') . '%');
    }
}
